package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyInstanceCreditSpecificationResponse(
    successfulInstanceCreditSpecifications: Option[
      Iterable[zio.aws.ec2.model.SuccessfulInstanceCreditSpecificationItem]
    ] = None,
    unsuccessfulInstanceCreditSpecifications: Option[
      Iterable[zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationResponse = {
    import ModifyInstanceCreditSpecificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationResponse
      .builder()
      .optionallyWith(
        successfulInstanceCreditSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successfulInstanceCreditSpecifications)
      .optionallyWith(
        unsuccessfulInstanceCreditSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessfulInstanceCreditSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyInstanceCreditSpecificationResponse.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceCreditSpecificationResponse
      .wrap(buildAwsValue())
}
object ModifyInstanceCreditSpecificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyInstanceCreditSpecificationResponse =
      zio.aws.ec2.model.ModifyInstanceCreditSpecificationResponse(
        successfulInstanceCreditSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unsuccessfulInstanceCreditSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successfulInstanceCreditSpecifications: Option[
      List[zio.aws.ec2.model.SuccessfulInstanceCreditSpecificationItem.ReadOnly]
    ]
    def unsuccessfulInstanceCreditSpecifications: Option[List[
      zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItem.ReadOnly
    ]]
    def getSuccessfulInstanceCreditSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SuccessfulInstanceCreditSpecificationItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "successfulInstanceCreditSpecifications",
      successfulInstanceCreditSpecifications
    )
    def getUnsuccessfulInstanceCreditSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unsuccessfulInstanceCreditSpecifications",
      unsuccessfulInstanceCreditSpecifications
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationResponse
  ) extends zio.aws.ec2.model.ModifyInstanceCreditSpecificationResponse.ReadOnly {
    override val successfulInstanceCreditSpecifications: Option[
      List[zio.aws.ec2.model.SuccessfulInstanceCreditSpecificationItem.ReadOnly]
    ] = scala
      .Option(impl.successfulInstanceCreditSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SuccessfulInstanceCreditSpecificationItem.wrap(item)
        }.toList
      )
    override val unsuccessfulInstanceCreditSpecifications: Option[List[
      zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItem.ReadOnly
    ]] = scala
      .Option(impl.unsuccessfulInstanceCreditSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItem
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationResponse
  ): zio.aws.ec2.model.ModifyInstanceCreditSpecificationResponse.ReadOnly =
    new Wrapper(impl)
}
