package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SnapshotId, KmsKeyId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateEbsBlockDeviceRequest(
    encrypted: Option[Boolean] = None,
    deleteOnTermination: Option[Boolean] = None,
    iops: Option[Integer] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    snapshotId: Option[SnapshotId] = None,
    volumeSize: Option[Integer] = None,
    volumeType: Option[zio.aws.ec2.model.VolumeType] = None,
    throughput: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateEbsBlockDeviceRequest = {
    import LaunchTemplateEbsBlockDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateEbsBlockDeviceRequest
      .builder()
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(
        iops.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.iops)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        volumeSize.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.volumeSize)
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(
        throughput.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.throughput)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateEbsBlockDeviceRequest.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateEbsBlockDeviceRequest.wrap(buildAwsValue())
}
object LaunchTemplateEbsBlockDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateEbsBlockDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateEbsBlockDeviceRequest =
      zio.aws.ec2.model.LaunchTemplateEbsBlockDeviceRequest(
        encrypted.map(value => value),
        deleteOnTermination.map(value => value),
        iops.map(value => value),
        kmsKeyId.map(value => value),
        snapshotId.map(value => value),
        volumeSize.map(value => value),
        volumeType.map(value => value),
        throughput.map(value => value)
      )
    def encrypted: Option[Boolean]
    def deleteOnTermination: Option[Boolean]
    def iops: Option[Integer]
    def kmsKeyId: Option[KmsKeyId]
    def snapshotId: Option[SnapshotId]
    def volumeSize: Option[Integer]
    def volumeType: Option[zio.aws.ec2.model.VolumeType]
    def throughput: Option[Integer]
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getVolumeType: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throughput", throughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateEbsBlockDeviceRequest
  ) extends zio.aws.ec2.model.LaunchTemplateEbsBlockDeviceRequest.ReadOnly {
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val deleteOnTermination: Option[Boolean] =
      scala.Option(impl.deleteOnTermination()).map(value => value: Boolean)
    override val iops: Option[Integer] = scala
      .Option(impl.iops())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.ec2.model.primitives.KmsKeyId(value))
    override val snapshotId: Option[SnapshotId] = scala
      .Option(impl.snapshotId())
      .map(value => zio.aws.ec2.model.primitives.SnapshotId(value))
    override val volumeSize: Option[Integer] = scala
      .Option(impl.volumeSize())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val volumeType: Option[zio.aws.ec2.model.VolumeType] = scala
      .Option(impl.volumeType())
      .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val throughput: Option[Integer] = scala
      .Option(impl.throughput())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateEbsBlockDeviceRequest
  ): zio.aws.ec2.model.LaunchTemplateEbsBlockDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
