package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Ipv6CidrBlock(ipv6CidrBlock: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Ipv6CidrBlock = {
    import Ipv6CidrBlock.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Ipv6CidrBlock
      .builder()
      .optionallyWith(ipv6CidrBlock.map(value => value: java.lang.String))(
        _.ipv6CidrBlock
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Ipv6CidrBlock.ReadOnly =
    zio.aws.ec2.model.Ipv6CidrBlock.wrap(buildAwsValue())
}
object Ipv6CidrBlock {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Ipv6CidrBlock] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Ipv6CidrBlock =
      zio.aws.ec2.model.Ipv6CidrBlock(ipv6CidrBlock.map(value => value))
    def ipv6CidrBlock: Option[String]
    def getIpv6CidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Ipv6CidrBlock
  ) extends zio.aws.ec2.model.Ipv6CidrBlock.ReadOnly {
    override val ipv6CidrBlock: Option[String] =
      scala.Option(impl.ipv6CidrBlock()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Ipv6CidrBlock
  ): zio.aws.ec2.model.Ipv6CidrBlock.ReadOnly = new Wrapper(impl)
}
