package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FleetLaunchTemplateConfig(
    launchTemplateSpecification: Option[
      zio.aws.ec2.model.FleetLaunchTemplateSpecification
    ] = None,
    overrides: Option[
      Iterable[zio.aws.ec2.model.FleetLaunchTemplateOverrides]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfig = {
    import FleetLaunchTemplateConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfig
      .builder()
      .optionallyWith(
        launchTemplateSpecification.map(value => value.buildAwsValue())
      )(_.launchTemplateSpecification)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FleetLaunchTemplateConfig.ReadOnly =
    zio.aws.ec2.model.FleetLaunchTemplateConfig.wrap(buildAwsValue())
}
object FleetLaunchTemplateConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetLaunchTemplateConfig =
      zio.aws.ec2.model.FleetLaunchTemplateConfig(
        launchTemplateSpecification.map(value => value.asEditable),
        overrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def launchTemplateSpecification
        : Option[zio.aws.ec2.model.FleetLaunchTemplateSpecification.ReadOnly]
    def overrides
        : Option[List[zio.aws.ec2.model.FleetLaunchTemplateOverrides.ReadOnly]]
    def getLaunchTemplateSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetLaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "launchTemplateSpecification",
      launchTemplateSpecification
    )
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.FleetLaunchTemplateOverrides.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfig
  ) extends zio.aws.ec2.model.FleetLaunchTemplateConfig.ReadOnly {
    override val launchTemplateSpecification
        : Option[zio.aws.ec2.model.FleetLaunchTemplateSpecification.ReadOnly] =
      scala
        .Option(impl.launchTemplateSpecification())
        .map(value =>
          zio.aws.ec2.model.FleetLaunchTemplateSpecification.wrap(value)
        )
    override val overrides: Option[
      List[zio.aws.ec2.model.FleetLaunchTemplateOverrides.ReadOnly]
    ] = scala
      .Option(impl.overrides())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.FleetLaunchTemplateOverrides.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfig
  ): zio.aws.ec2.model.FleetLaunchTemplateConfig.ReadOnly = new Wrapper(impl)
}
