package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ElasticGpuId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ElasticGpuAssociation(
    elasticGpuId: Option[ElasticGpuId] = None,
    elasticGpuAssociationId: Option[String] = None,
    elasticGpuAssociationState: Option[String] = None,
    elasticGpuAssociationTime: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation = {
    import ElasticGpuAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation
      .builder()
      .optionallyWith(
        elasticGpuId.map(value => ElasticGpuId.unwrap(value): java.lang.String)
      )(_.elasticGpuId)
      .optionallyWith(
        elasticGpuAssociationId.map(value => value: java.lang.String)
      )(_.elasticGpuAssociationId)
      .optionallyWith(
        elasticGpuAssociationState.map(value => value: java.lang.String)
      )(_.elasticGpuAssociationState)
      .optionallyWith(
        elasticGpuAssociationTime.map(value => value: java.lang.String)
      )(_.elasticGpuAssociationTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ElasticGpuAssociation.ReadOnly =
    zio.aws.ec2.model.ElasticGpuAssociation.wrap(buildAwsValue())
}
object ElasticGpuAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ElasticGpuAssociation =
      zio.aws.ec2.model.ElasticGpuAssociation(
        elasticGpuId.map(value => value),
        elasticGpuAssociationId.map(value => value),
        elasticGpuAssociationState.map(value => value),
        elasticGpuAssociationTime.map(value => value)
      )
    def elasticGpuId: Option[ElasticGpuId]
    def elasticGpuAssociationId: Option[String]
    def elasticGpuAssociationState: Option[String]
    def elasticGpuAssociationTime: Option[String]
    def getElasticGpuId: ZIO[Any, AwsError, ElasticGpuId] =
      AwsError.unwrapOptionField("elasticGpuId", elasticGpuId)
    def getElasticGpuAssociationId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("elasticGpuAssociationId", elasticGpuAssociationId)
    def getElasticGpuAssociationState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "elasticGpuAssociationState",
        elasticGpuAssociationState
      )
    def getElasticGpuAssociationTime: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("elasticGpuAssociationTime", elasticGpuAssociationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation
  ) extends zio.aws.ec2.model.ElasticGpuAssociation.ReadOnly {
    override val elasticGpuId: Option[ElasticGpuId] = scala
      .Option(impl.elasticGpuId())
      .map(value => zio.aws.ec2.model.primitives.ElasticGpuId(value))
    override val elasticGpuAssociationId: Option[String] =
      scala.Option(impl.elasticGpuAssociationId()).map(value => value: String)
    override val elasticGpuAssociationState: Option[String] = scala
      .Option(impl.elasticGpuAssociationState())
      .map(value => value: String)
    override val elasticGpuAssociationTime: Option[String] =
      scala.Option(impl.elasticGpuAssociationTime()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation
  ): zio.aws.ec2.model.ElasticGpuAssociation.ReadOnly = new Wrapper(impl)
}
