package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  VpcId,
  DescribeStaleSecurityGroupsNextToken,
  DescribeStaleSecurityGroupsMaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStaleSecurityGroupsRequest(
    maxResults: Option[DescribeStaleSecurityGroupsMaxResults] = None,
    nextToken: Option[DescribeStaleSecurityGroupsNextToken] = None,
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest = {
    import DescribeStaleSecurityGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          DescribeStaleSecurityGroupsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          DescribeStaleSecurityGroupsNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest.wrap(buildAwsValue())
}
object DescribeStaleSecurityGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest =
      zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        vpcId
      )
    def maxResults: Option[DescribeStaleSecurityGroupsMaxResults]
    def nextToken: Option[DescribeStaleSecurityGroupsNextToken]
    def vpcId: VpcId
    def getMaxResults
        : ZIO[Any, AwsError, DescribeStaleSecurityGroupsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, DescribeStaleSecurityGroupsNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest
  ) extends zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest.ReadOnly {
    override val maxResults: Option[DescribeStaleSecurityGroupsMaxResults] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeStaleSecurityGroupsMaxResults(value)
        )
    override val nextToken: Option[DescribeStaleSecurityGroupsNextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeStaleSecurityGroupsNextToken(value)
      )
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest
  ): zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
