package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, DedicatedHostId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHostsRequest(
    filter: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    hostIds: Option[Iterable[DedicatedHostId]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeHostsRequest = {
    import DescribeHostsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeHostsRequest
      .builder()
      .optionallyWith(
        filter.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filter)
      .optionallyWith(
        hostIds.map(value =>
          value.map { item =>
            DedicatedHostId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hostIds)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeHostsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeHostsRequest.wrap(buildAwsValue())
}
object DescribeHostsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeHostsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeHostsRequest =
      zio.aws.ec2.model.DescribeHostsRequest(
        filter.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hostIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def hostIds: Option[List[DedicatedHostId]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getFilter: ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filter", filter)
    def getHostIds: ZIO[Any, AwsError, List[DedicatedHostId]] =
      AwsError.unwrapOptionField("hostIds", hostIds)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostsRequest
  ) extends zio.aws.ec2.model.DescribeHostsRequest.ReadOnly {
    override val filter: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] = scala
      .Option(impl.filter())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Filter.wrap(item)
        }.toList
      )
    override val hostIds: Option[List[DedicatedHostId]] = scala
      .Option(impl.hostIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.DedicatedHostId(item)
        }.toList
      )
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostsRequest
  ): zio.aws.ec2.model.DescribeHostsRequest.ReadOnly = new Wrapper(impl)
}
