package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeExportImageTasksResponse(
    exportImageTasks: Option[Iterable[zio.aws.ec2.model.ExportImageTask]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse = {
    import DescribeExportImageTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse
      .builder()
      .optionallyWith(
        exportImageTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exportImageTasks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeExportImageTasksResponse.ReadOnly =
    zio.aws.ec2.model.DescribeExportImageTasksResponse.wrap(buildAwsValue())
}
object DescribeExportImageTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeExportImageTasksResponse =
      zio.aws.ec2.model.DescribeExportImageTasksResponse(
        exportImageTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def exportImageTasks
        : Option[List[zio.aws.ec2.model.ExportImageTask.ReadOnly]]
    def nextToken: Option[NextToken]
    def getExportImageTasks
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ExportImageTask.ReadOnly]] =
      AwsError.unwrapOptionField("exportImageTasks", exportImageTasks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse
  ) extends zio.aws.ec2.model.DescribeExportImageTasksResponse.ReadOnly {
    override val exportImageTasks
        : Option[List[zio.aws.ec2.model.ExportImageTask.ReadOnly]] = scala
      .Option(impl.exportImageTasks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ExportImageTask.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse
  ): zio.aws.ec2.model.DescribeExportImageTasksResponse.ReadOnly = new Wrapper(
    impl
  )
}
