package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInterfaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateNetworkInterfacePermissionRequest(
    networkInterfaceId: NetworkInterfaceId,
    awsAccountId: Option[String] = None,
    awsService: Option[String] = None,
    permission: zio.aws.ec2.model.InterfacePermissionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest = {
    import CreateNetworkInterfacePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest
      .builder()
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .optionallyWith(awsAccountId.map(value => value: java.lang.String))(
        _.awsAccountId
      )
      .optionallyWith(awsService.map(value => value: java.lang.String))(
        _.awsService
      )
      .permission(permission.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest.ReadOnly =
    zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest
      .wrap(buildAwsValue())
}
object CreateNetworkInterfacePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest =
      zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest(
        networkInterfaceId,
        awsAccountId.map(value => value),
        awsService.map(value => value),
        permission
      )
    def networkInterfaceId: NetworkInterfaceId
    def awsAccountId: Option[String]
    def awsService: Option[String]
    def permission: zio.aws.ec2.model.InterfacePermissionType
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getAwsAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getAwsService: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsService", awsService)
    def getPermission
        : ZIO[Any, Nothing, zio.aws.ec2.model.InterfacePermissionType] =
      ZIO.succeed(permission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest
  ) extends zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest.ReadOnly {
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
    override val awsAccountId: Option[String] =
      scala.Option(impl.awsAccountId()).map(value => value: String)
    override val awsService: Option[String] =
      scala.Option(impl.awsService()).map(value => value: String)
    override val permission: zio.aws.ec2.model.InterfacePermissionType =
      zio.aws.ec2.model.InterfacePermissionType.wrap(impl.permission())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest
  ): zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest.ReadOnly =
    new Wrapper(impl)
}
