package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait CpuManufacturer {
  def unwrap: software.amazon.awssdk.services.ec2.model.CpuManufacturer
}
object CpuManufacturer {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.CpuManufacturer
  ): zio.aws.ec2.model.CpuManufacturer = value match {
    case software.amazon.awssdk.services.ec2.model.CpuManufacturer.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.CpuManufacturer.INTEL =>
      val r = intel
      r
    case software.amazon.awssdk.services.ec2.model.CpuManufacturer.AMD =>
      val r = amd
      r
    case software.amazon.awssdk.services.ec2.model.CpuManufacturer.AMAZON_WEB_SERVICES =>
      val r = `amazon-web-services`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.CpuManufacturer {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CpuManufacturer =
      software.amazon.awssdk.services.ec2.model.CpuManufacturer.UNKNOWN_TO_SDK_VERSION
  }
  case object intel extends zio.aws.ec2.model.CpuManufacturer {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CpuManufacturer =
      software.amazon.awssdk.services.ec2.model.CpuManufacturer.INTEL
  }
  case object amd extends zio.aws.ec2.model.CpuManufacturer {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CpuManufacturer =
      software.amazon.awssdk.services.ec2.model.CpuManufacturer.AMD
  }
  case object `amazon-web-services` extends zio.aws.ec2.model.CpuManufacturer {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CpuManufacturer =
      software.amazon.awssdk.services.ec2.model.CpuManufacturer.AMAZON_WEB_SERVICES
  }
}
