package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.Port
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnalysisLoadBalancerListener(
    loadBalancerPort: Option[Port] = None,
    instancePort: Option[Port] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerListener = {
    import AnalysisLoadBalancerListener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerListener
      .builder()
      .optionallyWith(
        loadBalancerPort.map(value => Port.unwrap(value): Integer)
      )(_.loadBalancerPort)
      .optionallyWith(instancePort.map(value => Port.unwrap(value): Integer))(
        _.instancePort
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AnalysisLoadBalancerListener.ReadOnly =
    zio.aws.ec2.model.AnalysisLoadBalancerListener.wrap(buildAwsValue())
}
object AnalysisLoadBalancerListener {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerListener
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AnalysisLoadBalancerListener =
      zio.aws.ec2.model.AnalysisLoadBalancerListener(
        loadBalancerPort.map(value => value),
        instancePort.map(value => value)
      )
    def loadBalancerPort: Option[Port]
    def instancePort: Option[Port]
    def getLoadBalancerPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("loadBalancerPort", loadBalancerPort)
    def getInstancePort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("instancePort", instancePort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerListener
  ) extends zio.aws.ec2.model.AnalysisLoadBalancerListener.ReadOnly {
    override val loadBalancerPort: Option[Port] = scala
      .Option(impl.loadBalancerPort())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
    override val instancePort: Option[Port] = scala
      .Option(impl.instancePort())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerListener
  ): zio.aws.ec2.model.AnalysisLoadBalancerListener.ReadOnly = new Wrapper(impl)
}
