package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnalysisAclRule(
    cidr: Option[String] = None,
    egress: Option[Boolean] = None,
    portRange: Option[zio.aws.ec2.model.PortRange] = None,
    protocol: Option[String] = None,
    ruleAction: Option[String] = None,
    ruleNumber: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AnalysisAclRule = {
    import AnalysisAclRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AnalysisAclRule
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(egress.map(value => value: java.lang.Boolean))(_.egress)
      .optionallyWith(portRange.map(value => value.buildAwsValue()))(
        _.portRange
      )
      .optionallyWith(protocol.map(value => value: java.lang.String))(
        _.protocol
      )
      .optionallyWith(ruleAction.map(value => value: java.lang.String))(
        _.ruleAction
      )
      .optionallyWith(
        ruleNumber.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.ruleNumber)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AnalysisAclRule.ReadOnly =
    zio.aws.ec2.model.AnalysisAclRule.wrap(buildAwsValue())
}
object AnalysisAclRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AnalysisAclRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AnalysisAclRule =
      zio.aws.ec2.model.AnalysisAclRule(
        cidr.map(value => value),
        egress.map(value => value),
        portRange.map(value => value.asEditable),
        protocol.map(value => value),
        ruleAction.map(value => value),
        ruleNumber.map(value => value)
      )
    def cidr: Option[String]
    def egress: Option[Boolean]
    def portRange: Option[zio.aws.ec2.model.PortRange.ReadOnly]
    def protocol: Option[String]
    def ruleAction: Option[String]
    def ruleNumber: Option[Integer]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getEgress: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("egress", egress)
    def getPortRange: ZIO[Any, AwsError, zio.aws.ec2.model.PortRange.ReadOnly] =
      AwsError.unwrapOptionField("portRange", portRange)
    def getProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getRuleAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleAction", ruleAction)
    def getRuleNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ruleNumber", ruleNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisAclRule
  ) extends zio.aws.ec2.model.AnalysisAclRule.ReadOnly {
    override val cidr: Option[String] =
      scala.Option(impl.cidr()).map(value => value: String)
    override val egress: Option[Boolean] =
      scala.Option(impl.egress()).map(value => value: Boolean)
    override val portRange: Option[zio.aws.ec2.model.PortRange.ReadOnly] = scala
      .Option(impl.portRange())
      .map(value => zio.aws.ec2.model.PortRange.wrap(value))
    override val protocol: Option[String] =
      scala.Option(impl.protocol()).map(value => value: String)
    override val ruleAction: Option[String] =
      scala.Option(impl.ruleAction()).map(value => value: String)
    override val ruleNumber: Option[Integer] = scala
      .Option(impl.ruleNumber())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisAclRule
  ): zio.aws.ec2.model.AnalysisAclRule.ReadOnly = new Wrapper(impl)
}
