package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VolumeStatusInfo(
    details: Option[Iterable[zio.aws.ec2.model.VolumeStatusDetails]] = None,
    status: Option[zio.aws.ec2.model.VolumeStatusInfoStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeStatusInfo = {
    import VolumeStatusInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeStatusInfo
      .builder()
      .optionallyWith(
        details.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.details)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeStatusInfo.ReadOnly =
    zio.aws.ec2.model.VolumeStatusInfo.wrap(buildAwsValue())
}
object VolumeStatusInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VolumeStatusInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeStatusInfo =
      zio.aws.ec2.model.VolumeStatusInfo(
        details.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value)
      )
    def details: Option[List[zio.aws.ec2.model.VolumeStatusDetails.ReadOnly]]
    def status: Option[zio.aws.ec2.model.VolumeStatusInfoStatus]
    def getDetails: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VolumeStatusDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("details", details)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.VolumeStatusInfoStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusInfo
  ) extends zio.aws.ec2.model.VolumeStatusInfo.ReadOnly {
    override val details
        : Option[List[zio.aws.ec2.model.VolumeStatusDetails.ReadOnly]] = scala
      .Option(impl.details())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VolumeStatusDetails.wrap(item)
        }.toList
      )
    override val status: Option[zio.aws.ec2.model.VolumeStatusInfoStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.ec2.model.VolumeStatusInfoStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusInfo
  ): zio.aws.ec2.model.VolumeStatusInfo.ReadOnly = new Wrapper(impl)
}
