package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait SummaryStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.SummaryStatus
}
object SummaryStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.SummaryStatus
  ): zio.aws.ec2.model.SummaryStatus = value match {
    case software.amazon.awssdk.services.ec2.model.SummaryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.SummaryStatus.OK =>
      val r = ok
      r
    case software.amazon.awssdk.services.ec2.model.SummaryStatus.IMPAIRED =>
      val r = impaired
      r
    case software.amazon.awssdk.services.ec2.model.SummaryStatus.INSUFFICIENT_DATA =>
      val r = `insufficient-data`
      r
    case software.amazon.awssdk.services.ec2.model.SummaryStatus.NOT_APPLICABLE =>
      val r = `not-applicable`
      r
    case software.amazon.awssdk.services.ec2.model.SummaryStatus.INITIALIZING =>
      val r = initializing
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.SummaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SummaryStatus =
      software.amazon.awssdk.services.ec2.model.SummaryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ok extends zio.aws.ec2.model.SummaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SummaryStatus =
      software.amazon.awssdk.services.ec2.model.SummaryStatus.OK
  }
  case object impaired extends zio.aws.ec2.model.SummaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SummaryStatus =
      software.amazon.awssdk.services.ec2.model.SummaryStatus.IMPAIRED
  }
  case object `insufficient-data` extends zio.aws.ec2.model.SummaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SummaryStatus =
      software.amazon.awssdk.services.ec2.model.SummaryStatus.INSUFFICIENT_DATA
  }
  case object `not-applicable` extends zio.aws.ec2.model.SummaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SummaryStatus =
      software.amazon.awssdk.services.ec2.model.SummaryStatus.NOT_APPLICABLE
  }
  case object initializing extends zio.aws.ec2.model.SummaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SummaryStatus =
      software.amazon.awssdk.services.ec2.model.SummaryStatus.INITIALIZING
  }
}
