package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{InstanceId, DateTime, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SpotInstanceRequest(
    actualBlockHourlyPrice: Option[String] = None,
    availabilityZoneGroup: Option[String] = None,
    blockDurationMinutes: Option[Integer] = None,
    createTime: Option[DateTime] = None,
    fault: Option[zio.aws.ec2.model.SpotInstanceStateFault] = None,
    instanceId: Option[InstanceId] = None,
    launchGroup: Option[String] = None,
    launchSpecification: Option[zio.aws.ec2.model.LaunchSpecification] = None,
    launchedAvailabilityZone: Option[String] = None,
    productDescription: Option[zio.aws.ec2.model.RIProductDescription] = None,
    spotInstanceRequestId: Option[String] = None,
    spotPrice: Option[String] = None,
    state: Option[zio.aws.ec2.model.SpotInstanceState] = None,
    status: Option[zio.aws.ec2.model.SpotInstanceStatus] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    `type`: Option[zio.aws.ec2.model.SpotInstanceType] = None,
    validFrom: Option[DateTime] = None,
    validUntil: Option[DateTime] = None,
    instanceInterruptionBehavior: Option[
      zio.aws.ec2.model.InstanceInterruptionBehavior
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotInstanceRequest = {
    import SpotInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotInstanceRequest
      .builder()
      .optionallyWith(
        actualBlockHourlyPrice.map(value => value: java.lang.String)
      )(_.actualBlockHourlyPrice)
      .optionallyWith(
        availabilityZoneGroup.map(value => value: java.lang.String)
      )(_.availabilityZoneGroup)
      .optionallyWith(
        blockDurationMinutes.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.blockDurationMinutes)
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(fault.map(value => value.buildAwsValue()))(_.fault)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(launchGroup.map(value => value: java.lang.String))(
        _.launchGroup
      )
      .optionallyWith(launchSpecification.map(value => value.buildAwsValue()))(
        _.launchSpecification
      )
      .optionallyWith(
        launchedAvailabilityZone.map(value => value: java.lang.String)
      )(_.launchedAvailabilityZone)
      .optionallyWith(productDescription.map(value => value.unwrap))(
        _.productDescription
      )
      .optionallyWith(
        spotInstanceRequestId.map(value => value: java.lang.String)
      )(_.spotInstanceRequestId)
      .optionallyWith(spotPrice.map(value => value: java.lang.String))(
        _.spotPrice
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(validFrom.map(value => DateTime.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validUntil.map(value => DateTime.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(instanceInterruptionBehavior.map(value => value.unwrap))(
        _.instanceInterruptionBehavior
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotInstanceRequest.ReadOnly =
    zio.aws.ec2.model.SpotInstanceRequest.wrap(buildAwsValue())
}
object SpotInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotInstanceRequest =
      zio.aws.ec2.model.SpotInstanceRequest(
        actualBlockHourlyPrice.map(value => value),
        availabilityZoneGroup.map(value => value),
        blockDurationMinutes.map(value => value),
        createTime.map(value => value),
        fault.map(value => value.asEditable),
        instanceId.map(value => value),
        launchGroup.map(value => value),
        launchSpecification.map(value => value.asEditable),
        launchedAvailabilityZone.map(value => value),
        productDescription.map(value => value),
        spotInstanceRequestId.map(value => value),
        spotPrice.map(value => value),
        state.map(value => value),
        status.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value => value),
        validFrom.map(value => value),
        validUntil.map(value => value),
        instanceInterruptionBehavior.map(value => value)
      )
    def actualBlockHourlyPrice: Option[String]
    def availabilityZoneGroup: Option[String]
    def blockDurationMinutes: Option[Integer]
    def createTime: Option[DateTime]
    def fault: Option[zio.aws.ec2.model.SpotInstanceStateFault.ReadOnly]
    def instanceId: Option[InstanceId]
    def launchGroup: Option[String]
    def launchSpecification
        : Option[zio.aws.ec2.model.LaunchSpecification.ReadOnly]
    def launchedAvailabilityZone: Option[String]
    def productDescription: Option[zio.aws.ec2.model.RIProductDescription]
    def spotInstanceRequestId: Option[String]
    def spotPrice: Option[String]
    def state: Option[zio.aws.ec2.model.SpotInstanceState]
    def status: Option[zio.aws.ec2.model.SpotInstanceStatus.ReadOnly]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def `type`: Option[zio.aws.ec2.model.SpotInstanceType]
    def validFrom: Option[DateTime]
    def validUntil: Option[DateTime]
    def instanceInterruptionBehavior
        : Option[zio.aws.ec2.model.InstanceInterruptionBehavior]
    def getActualBlockHourlyPrice: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("actualBlockHourlyPrice", actualBlockHourlyPrice)
    def getAvailabilityZoneGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneGroup", availabilityZoneGroup)
    def getBlockDurationMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("blockDurationMinutes", blockDurationMinutes)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getFault: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SpotInstanceStateFault.ReadOnly
    ] = AwsError.unwrapOptionField("fault", fault)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getLaunchGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchGroup", launchGroup)
    def getLaunchSpecification
        : ZIO[Any, AwsError, zio.aws.ec2.model.LaunchSpecification.ReadOnly] =
      AwsError.unwrapOptionField("launchSpecification", launchSpecification)
    def getLaunchedAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("launchedAvailabilityZone", launchedAvailabilityZone)
    def getProductDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.RIProductDescription] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getSpotInstanceRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotInstanceRequestId", spotInstanceRequestId)
    def getSpotPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.SpotInstanceState] =
      AwsError.unwrapOptionField("state", state)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotInstanceStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.SpotInstanceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValidFrom: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidUntil: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getInstanceInterruptionBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceInterruptionBehavior] =
      AwsError.unwrapOptionField(
        "instanceInterruptionBehavior",
        instanceInterruptionBehavior
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotInstanceRequest
  ) extends zio.aws.ec2.model.SpotInstanceRequest.ReadOnly {
    override val actualBlockHourlyPrice: Option[String] =
      scala.Option(impl.actualBlockHourlyPrice()).map(value => value: String)
    override val availabilityZoneGroup: Option[String] =
      scala.Option(impl.availabilityZoneGroup()).map(value => value: String)
    override val blockDurationMinutes: Option[Integer] = scala
      .Option(impl.blockDurationMinutes())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val createTime: Option[DateTime] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val fault
        : Option[zio.aws.ec2.model.SpotInstanceStateFault.ReadOnly] = scala
      .Option(impl.fault())
      .map(value => zio.aws.ec2.model.SpotInstanceStateFault.wrap(value))
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.ec2.model.primitives.InstanceId(value))
    override val launchGroup: Option[String] =
      scala.Option(impl.launchGroup()).map(value => value: String)
    override val launchSpecification
        : Option[zio.aws.ec2.model.LaunchSpecification.ReadOnly] = scala
      .Option(impl.launchSpecification())
      .map(value => zio.aws.ec2.model.LaunchSpecification.wrap(value))
    override val launchedAvailabilityZone: Option[String] =
      scala.Option(impl.launchedAvailabilityZone()).map(value => value: String)
    override val productDescription
        : Option[zio.aws.ec2.model.RIProductDescription] = scala
      .Option(impl.productDescription())
      .map(value => zio.aws.ec2.model.RIProductDescription.wrap(value))
    override val spotInstanceRequestId: Option[String] =
      scala.Option(impl.spotInstanceRequestId()).map(value => value: String)
    override val spotPrice: Option[String] =
      scala.Option(impl.spotPrice()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.SpotInstanceState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.SpotInstanceState.wrap(value))
    override val status: Option[zio.aws.ec2.model.SpotInstanceStatus.ReadOnly] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.ec2.model.SpotInstanceStatus.wrap(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val `type`: Option[zio.aws.ec2.model.SpotInstanceType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ec2.model.SpotInstanceType.wrap(value))
    override val validFrom: Option[DateTime] = scala
      .Option(impl.validFrom())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val validUntil: Option[DateTime] = scala
      .Option(impl.validUntil())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val instanceInterruptionBehavior
        : Option[zio.aws.ec2.model.InstanceInterruptionBehavior] = scala
      .Option(impl.instanceInterruptionBehavior())
      .map(value => zio.aws.ec2.model.InstanceInterruptionBehavior.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotInstanceRequest
  ): zio.aws.ec2.model.SpotInstanceRequest.ReadOnly = new Wrapper(impl)
}
