package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SnapshotDiskContainer(
    description: Option[String] = None,
    format: Option[String] = None,
    url: Option[String] = None,
    userBucket: Option[zio.aws.ec2.model.UserBucket] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer = {
    import SnapshotDiskContainer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(userBucket.map(value => value.buildAwsValue()))(
        _.userBucket
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SnapshotDiskContainer.ReadOnly =
    zio.aws.ec2.model.SnapshotDiskContainer.wrap(buildAwsValue())
}
object SnapshotDiskContainer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SnapshotDiskContainer =
      zio.aws.ec2.model.SnapshotDiskContainer(
        description.map(value => value),
        format.map(value => value),
        url.map(value => value),
        userBucket.map(value => value.asEditable)
      )
    def description: Option[String]
    def format: Option[String]
    def url: Option[String]
    def userBucket: Option[zio.aws.ec2.model.UserBucket.ReadOnly]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
    def getUserBucket
        : ZIO[Any, AwsError, zio.aws.ec2.model.UserBucket.ReadOnly] =
      AwsError.unwrapOptionField("userBucket", userBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer
  ) extends zio.aws.ec2.model.SnapshotDiskContainer.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val format: Option[String] =
      scala.Option(impl.format()).map(value => value: String)
    override val url: Option[String] =
      scala.Option(impl.url()).map(value => value: String)
    override val userBucket: Option[zio.aws.ec2.model.UserBucket.ReadOnly] =
      scala
        .Option(impl.userBucket())
        .map(value => zio.aws.ec2.model.UserBucket.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer
  ): zio.aws.ec2.model.SnapshotDiskContainer.ReadOnly = new Wrapper(impl)
}
