package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RunScheduledInstancesResponse(
    instanceIdSet: Option[Iterable[InstanceId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RunScheduledInstancesResponse = {
    import RunScheduledInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RunScheduledInstancesResponse
      .builder()
      .optionallyWith(
        instanceIdSet.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIdSet)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RunScheduledInstancesResponse.ReadOnly =
    zio.aws.ec2.model.RunScheduledInstancesResponse.wrap(buildAwsValue())
}
object RunScheduledInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RunScheduledInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RunScheduledInstancesResponse =
      zio.aws.ec2.model
        .RunScheduledInstancesResponse(instanceIdSet.map(value => value))
    def instanceIdSet: Option[List[InstanceId]]
    def getInstanceIdSet: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instanceIdSet", instanceIdSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RunScheduledInstancesResponse
  ) extends zio.aws.ec2.model.RunScheduledInstancesResponse.ReadOnly {
    override val instanceIdSet: Option[List[InstanceId]] = scala
      .Option(impl.instanceIdSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.InstanceId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RunScheduledInstancesResponse
  ): zio.aws.ec2.model.RunScheduledInstancesResponse.ReadOnly = new Wrapper(
    impl
  )
}
