package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, DateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ReservedInstances(
    availabilityZone: Option[String] = None,
    duration: Option[Long] = None,
    end: Option[DateTime] = None,
    fixedPrice: Option[Float] = None,
    instanceCount: Option[Integer] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    productDescription: Option[zio.aws.ec2.model.RIProductDescription] = None,
    reservedInstancesId: Option[String] = None,
    start: Option[DateTime] = None,
    state: Option[zio.aws.ec2.model.ReservedInstanceState] = None,
    usagePrice: Option[Float] = None,
    currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] = None,
    instanceTenancy: Option[zio.aws.ec2.model.Tenancy] = None,
    offeringClass: Option[zio.aws.ec2.model.OfferingClassType] = None,
    offeringType: Option[zio.aws.ec2.model.OfferingTypeValues] = None,
    recurringCharges: Option[Iterable[zio.aws.ec2.model.RecurringCharge]] =
      None,
    scope: Option[zio.aws.ec2.model.Scope] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservedInstances = {
    import ReservedInstances.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservedInstances
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(duration.map(value => value: java.lang.Long))(_.duration)
      .optionallyWith(end.map(value => DateTime.unwrap(value): Instant))(_.end)
      .optionallyWith(fixedPrice.map(value => value: java.lang.Float))(
        _.fixedPrice
      )
      .optionallyWith(
        instanceCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.instanceCount)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(productDescription.map(value => value.unwrap))(
        _.productDescription
      )
      .optionallyWith(
        reservedInstancesId.map(value => value: java.lang.String)
      )(_.reservedInstancesId)
      .optionallyWith(start.map(value => DateTime.unwrap(value): Instant))(
        _.start
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(usagePrice.map(value => value: java.lang.Float))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(instanceTenancy.map(value => value.unwrap))(
        _.instanceTenancy
      )
      .optionallyWith(offeringClass.map(value => value.unwrap))(_.offeringClass)
      .optionallyWith(offeringType.map(value => value.unwrap))(_.offeringType)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservedInstances.ReadOnly =
    zio.aws.ec2.model.ReservedInstances.wrap(buildAwsValue())
}
object ReservedInstances {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservedInstances
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservedInstances =
      zio.aws.ec2.model.ReservedInstances(
        availabilityZone.map(value => value),
        duration.map(value => value),
        end.map(value => value),
        fixedPrice.map(value => value),
        instanceCount.map(value => value),
        instanceType.map(value => value),
        productDescription.map(value => value),
        reservedInstancesId.map(value => value),
        start.map(value => value),
        state.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        instanceTenancy.map(value => value),
        offeringClass.map(value => value),
        offeringType.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scope.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def availabilityZone: Option[String]
    def duration: Option[Long]
    def end: Option[DateTime]
    def fixedPrice: Option[Float]
    def instanceCount: Option[Integer]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def productDescription: Option[zio.aws.ec2.model.RIProductDescription]
    def reservedInstancesId: Option[String]
    def start: Option[DateTime]
    def state: Option[zio.aws.ec2.model.ReservedInstanceState]
    def usagePrice: Option[Float]
    def currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues]
    def instanceTenancy: Option[zio.aws.ec2.model.Tenancy]
    def offeringClass: Option[zio.aws.ec2.model.OfferingClassType]
    def offeringType: Option[zio.aws.ec2.model.OfferingTypeValues]
    def recurringCharges
        : Option[List[zio.aws.ec2.model.RecurringCharge.ReadOnly]]
    def scope: Option[zio.aws.ec2.model.Scope]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("duration", duration)
    def getEnd: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("end", end)
    def getFixedPrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getProductDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.RIProductDescription] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getReservedInstancesId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedInstancesId", reservedInstancesId)
    def getStart: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("start", start)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.ReservedInstanceState] =
      AwsError.unwrapOptionField("state", state)
    def getUsagePrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getInstanceTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("instanceTenancy", instanceTenancy)
    def getOfferingClass
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingClassType] =
      AwsError.unwrapOptionField("offeringClass", offeringClass)
    def getOfferingType
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingTypeValues] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getRecurringCharges
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.RecurringCharge.ReadOnly]] =
      AwsError.unwrapOptionField("recurringCharges", recurringCharges)
    def getScope: ZIO[Any, AwsError, zio.aws.ec2.model.Scope] =
      AwsError.unwrapOptionField("scope", scope)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstances
  ) extends zio.aws.ec2.model.ReservedInstances.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val duration: Option[Long] =
      scala.Option(impl.duration()).map(value => value: Long)
    override val end: Option[DateTime] = scala
      .Option(impl.end())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val fixedPrice: Option[Float] =
      scala.Option(impl.fixedPrice()).map(value => value: Float)
    override val instanceCount: Option[Integer] = scala
      .Option(impl.instanceCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val productDescription
        : Option[zio.aws.ec2.model.RIProductDescription] = scala
      .Option(impl.productDescription())
      .map(value => zio.aws.ec2.model.RIProductDescription.wrap(value))
    override val reservedInstancesId: Option[String] =
      scala.Option(impl.reservedInstancesId()).map(value => value: String)
    override val start: Option[DateTime] = scala
      .Option(impl.start())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val state: Option[zio.aws.ec2.model.ReservedInstanceState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.ReservedInstanceState.wrap(value))
    override val usagePrice: Option[Float] =
      scala.Option(impl.usagePrice()).map(value => value: Float)
    override val currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] =
      scala
        .Option(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val instanceTenancy: Option[zio.aws.ec2.model.Tenancy] = scala
      .Option(impl.instanceTenancy())
      .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val offeringClass: Option[zio.aws.ec2.model.OfferingClassType] =
      scala
        .Option(impl.offeringClass())
        .map(value => zio.aws.ec2.model.OfferingClassType.wrap(value))
    override val offeringType: Option[zio.aws.ec2.model.OfferingTypeValues] =
      scala
        .Option(impl.offeringType())
        .map(value => zio.aws.ec2.model.OfferingTypeValues.wrap(value))
    override val recurringCharges
        : Option[List[zio.aws.ec2.model.RecurringCharge.ReadOnly]] = scala
      .Option(impl.recurringCharges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.RecurringCharge.wrap(item)
        }.toList
      )
    override val scope: Option[zio.aws.ec2.model.Scope] = scala
      .Option(impl.scope())
      .map(value => zio.aws.ec2.model.Scope.wrap(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstances
  ): zio.aws.ec2.model.ReservedInstances.ReadOnly = new Wrapper(impl)
}
