package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterImageResponse(imageId: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterImageResponse = {
    import RegisterImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterImageResponse
      .builder()
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RegisterImageResponse.ReadOnly =
    zio.aws.ec2.model.RegisterImageResponse.wrap(buildAwsValue())
}
object RegisterImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RegisterImageResponse =
      zio.aws.ec2.model.RegisterImageResponse(imageId.map(value => value))
    def imageId: Option[String]
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterImageResponse
  ) extends zio.aws.ec2.model.RegisterImageResponse.ReadOnly {
    override val imageId: Option[String] =
      scala.Option(impl.imageId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterImageResponse
  ): zio.aws.ec2.model.RegisterImageResponse.ReadOnly = new Wrapper(impl)
}
