package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait MoveStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.MoveStatus
}
object MoveStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.MoveStatus
  ): zio.aws.ec2.model.MoveStatus = value match {
    case software.amazon.awssdk.services.ec2.model.MoveStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.MoveStatus.MOVING_TO_VPC =>
      val r = movingToVpc
      r
    case software.amazon.awssdk.services.ec2.model.MoveStatus.RESTORING_TO_CLASSIC =>
      val r = restoringToClassic
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.MoveStatus {
    override def unwrap: software.amazon.awssdk.services.ec2.model.MoveStatus =
      software.amazon.awssdk.services.ec2.model.MoveStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object movingToVpc extends zio.aws.ec2.model.MoveStatus {
    override def unwrap: software.amazon.awssdk.services.ec2.model.MoveStatus =
      software.amazon.awssdk.services.ec2.model.MoveStatus.MOVING_TO_VPC
  }
  case object restoringToClassic extends zio.aws.ec2.model.MoveStatus {
    override def unwrap: software.amazon.awssdk.services.ec2.model.MoveStatus =
      software.amazon.awssdk.services.ec2.model.MoveStatus.RESTORING_TO_CLASSIC
  }
}
