package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait MonitoringState {
  def unwrap: software.amazon.awssdk.services.ec2.model.MonitoringState
}
object MonitoringState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.MonitoringState
  ): zio.aws.ec2.model.MonitoringState = value match {
    case software.amazon.awssdk.services.ec2.model.MonitoringState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.MonitoringState.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.ec2.model.MonitoringState.DISABLING =>
      val r = disabling
      r
    case software.amazon.awssdk.services.ec2.model.MonitoringState.ENABLED =>
      val r = enabled
      r
    case software.amazon.awssdk.services.ec2.model.MonitoringState.PENDING =>
      val r = pending
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.MonitoringState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.MonitoringState =
      software.amazon.awssdk.services.ec2.model.MonitoringState.UNKNOWN_TO_SDK_VERSION
  }
  case object disabled extends zio.aws.ec2.model.MonitoringState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.MonitoringState =
      software.amazon.awssdk.services.ec2.model.MonitoringState.DISABLED
  }
  case object disabling extends zio.aws.ec2.model.MonitoringState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.MonitoringState =
      software.amazon.awssdk.services.ec2.model.MonitoringState.DISABLING
  }
  case object enabled extends zio.aws.ec2.model.MonitoringState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.MonitoringState =
      software.amazon.awssdk.services.ec2.model.MonitoringState.ENABLED
  }
  case object pending extends zio.aws.ec2.model.MonitoringState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.MonitoringState =
      software.amazon.awssdk.services.ec2.model.MonitoringState.PENDING
  }
}
