package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVpcEndpointServiceConfigurationResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationResponse = {
    import ModifyVpcEndpointServiceConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationResponse
      .wrap(buildAwsValue())
}
object ModifyVpcEndpointServiceConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationResponse =
      zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationResponse(
        returnValue.map(value => value)
      )
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationResponse
  ) extends zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationResponse
  ): zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
