package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamScopeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyIpamScopeRequest(
    ipamScopeId: IpamScopeId,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest = {
    import ModifyIpamScopeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest
      .builder()
      .ipamScopeId(IpamScopeId.unwrap(ipamScopeId): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyIpamScopeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyIpamScopeRequest.wrap(buildAwsValue())
}
object ModifyIpamScopeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyIpamScopeRequest = zio.aws.ec2.model
      .ModifyIpamScopeRequest(ipamScopeId, description.map(value => value))
    def ipamScopeId: IpamScopeId
    def description: Option[String]
    def getIpamScopeId: ZIO[Any, Nothing, IpamScopeId] =
      ZIO.succeed(ipamScopeId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest
  ) extends zio.aws.ec2.model.ModifyIpamScopeRequest.ReadOnly {
    override val ipamScopeId: IpamScopeId =
      zio.aws.ec2.model.primitives.IpamScopeId(impl.ipamScopeId())
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest
  ): zio.aws.ec2.model.ModifyIpamScopeRequest.ReadOnly = new Wrapper(impl)
}
