package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.LocalGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LocalGateway(
    localGatewayId: Option[LocalGatewayId] = None,
    outpostArn: Option[String] = None,
    ownerId: Option[String] = None,
    state: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LocalGateway = {
    import LocalGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LocalGateway
      .builder()
      .optionallyWith(
        localGatewayId.map(value =>
          LocalGatewayId.unwrap(value): java.lang.String
        )
      )(_.localGatewayId)
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LocalGateway.ReadOnly =
    zio.aws.ec2.model.LocalGateway.wrap(buildAwsValue())
}
object LocalGateway {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.LocalGateway] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LocalGateway =
      zio.aws.ec2.model.LocalGateway(
        localGatewayId.map(value => value),
        outpostArn.map(value => value),
        ownerId.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def localGatewayId: Option[LocalGatewayId]
    def outpostArn: Option[String]
    def ownerId: Option[String]
    def state: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getLocalGatewayId: ZIO[Any, AwsError, LocalGatewayId] =
      AwsError.unwrapOptionField("localGatewayId", localGatewayId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LocalGateway
  ) extends zio.aws.ec2.model.LocalGateway.ReadOnly {
    override val localGatewayId: Option[LocalGatewayId] = scala
      .Option(impl.localGatewayId())
      .map(value => zio.aws.ec2.model.primitives.LocalGatewayId(value))
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val state: Option[String] =
      scala.Option(impl.state()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LocalGateway
  ): zio.aws.ec2.model.LocalGateway.ReadOnly = new Wrapper(impl)
}
