package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSnapshotsInRecycleBinResponse(
    snapshots: Option[Iterable[zio.aws.ec2.model.SnapshotRecycleBinInfo]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinResponse = {
    import ListSnapshotsInRecycleBinResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinResponse
      .builder()
      .optionallyWith(
        snapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshots)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ListSnapshotsInRecycleBinResponse.ReadOnly =
    zio.aws.ec2.model.ListSnapshotsInRecycleBinResponse.wrap(buildAwsValue())
}
object ListSnapshotsInRecycleBinResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ListSnapshotsInRecycleBinResponse =
      zio.aws.ec2.model.ListSnapshotsInRecycleBinResponse(
        snapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def snapshots
        : Option[List[zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly]]
    def nextToken: Option[String]
    def getSnapshots: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("snapshots", snapshots)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinResponse
  ) extends zio.aws.ec2.model.ListSnapshotsInRecycleBinResponse.ReadOnly {
    override val snapshots
        : Option[List[zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly]] =
      scala
        .Option(impl.snapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SnapshotRecycleBinInfo.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinResponse
  ): zio.aws.ec2.model.ListSnapshotsInRecycleBinResponse.ReadOnly = new Wrapper(
    impl
  )
}
