package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LaunchTemplateInstanceMetadataOptionsState {
  def unwrap: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsState
}
object LaunchTemplateInstanceMetadataOptionsState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsState
  ): zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsState =
    value match {
      case software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsState.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsState.PENDING =>
        val r = pending
        r
      case software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsState.APPLIED =>
        val r = applied
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending
      extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsState.PENDING
  }
  case object applied
      extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsState.APPLIED
  }
}
