package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DedicatedHostId, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceEventWindowAssociationRequest(
    instanceIds: Option[Iterable[InstanceId]] = None,
    instanceTags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    dedicatedHostIds: Option[Iterable[DedicatedHostId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceEventWindowAssociationRequest = {
    import InstanceEventWindowAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowAssociationRequest
      .builder()
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(
        instanceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTags)
      .optionallyWith(
        dedicatedHostIds.map(value =>
          value.map { item =>
            DedicatedHostId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dedicatedHostIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.InstanceEventWindowAssociationRequest.ReadOnly =
    zio.aws.ec2.model.InstanceEventWindowAssociationRequest
      .wrap(buildAwsValue())
}
object InstanceEventWindowAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceEventWindowAssociationRequest =
      zio.aws.ec2.model.InstanceEventWindowAssociationRequest(
        instanceIds.map(value => value),
        instanceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dedicatedHostIds.map(value => value)
      )
    def instanceIds: Option[List[InstanceId]]
    def instanceTags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def dedicatedHostIds: Option[List[DedicatedHostId]]
    def getInstanceIds: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getInstanceTags
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("instanceTags", instanceTags)
    def getDedicatedHostIds: ZIO[Any, AwsError, List[DedicatedHostId]] =
      AwsError.unwrapOptionField("dedicatedHostIds", dedicatedHostIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowAssociationRequest
  ) extends zio.aws.ec2.model.InstanceEventWindowAssociationRequest.ReadOnly {
    override val instanceIds: Option[List[InstanceId]] = scala
      .Option(impl.instanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.InstanceId(item)
        }.toList
      )
    override val instanceTags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      scala
        .Option(impl.instanceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val dedicatedHostIds: Option[List[DedicatedHostId]] = scala
      .Option(impl.dedicatedHostIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.DedicatedHostId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowAssociationRequest
  ): zio.aws.ec2.model.InstanceEventWindowAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
