package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.KmsKeyId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportSnapshotRequest(
    clientData: Option[zio.aws.ec2.model.ClientData] = None,
    clientToken: Option[String] = None,
    description: Option[String] = None,
    diskContainer: Option[zio.aws.ec2.model.SnapshotDiskContainer] = None,
    encrypted: Option[Boolean] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    roleName: Option[String] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest = {
    import ImportSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest
      .builder()
      .optionallyWith(clientData.map(value => value.buildAwsValue()))(
        _.clientData
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(diskContainer.map(value => value.buildAwsValue()))(
        _.diskContainer
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(roleName.map(value => value: java.lang.String))(
        _.roleName
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportSnapshotRequest.ReadOnly =
    zio.aws.ec2.model.ImportSnapshotRequest.wrap(buildAwsValue())
}
object ImportSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportSnapshotRequest =
      zio.aws.ec2.model.ImportSnapshotRequest(
        clientData.map(value => value.asEditable),
        clientToken.map(value => value),
        description.map(value => value),
        diskContainer.map(value => value.asEditable),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        roleName.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientData: Option[zio.aws.ec2.model.ClientData.ReadOnly]
    def clientToken: Option[String]
    def description: Option[String]
    def diskContainer: Option[zio.aws.ec2.model.SnapshotDiskContainer.ReadOnly]
    def encrypted: Option[Boolean]
    def kmsKeyId: Option[KmsKeyId]
    def roleName: Option[String]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getClientData
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientData.ReadOnly] =
      AwsError.unwrapOptionField("clientData", clientData)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDiskContainer
        : ZIO[Any, AwsError, zio.aws.ec2.model.SnapshotDiskContainer.ReadOnly] =
      AwsError.unwrapOptionField("diskContainer", diskContainer)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest
  ) extends zio.aws.ec2.model.ImportSnapshotRequest.ReadOnly {
    override val clientData: Option[zio.aws.ec2.model.ClientData.ReadOnly] =
      scala
        .Option(impl.clientData())
        .map(value => zio.aws.ec2.model.ClientData.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val diskContainer
        : Option[zio.aws.ec2.model.SnapshotDiskContainer.ReadOnly] = scala
      .Option(impl.diskContainer())
      .map(value => zio.aws.ec2.model.SnapshotDiskContainer.wrap(value))
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.ec2.model.primitives.KmsKeyId(value))
    override val roleName: Option[String] =
      scala.Option(impl.roleName()).map(value => value: String)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest
  ): zio.aws.ec2.model.ImportSnapshotRequest.ReadOnly = new Wrapper(impl)
}
