package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  GpuDeviceCount,
  GpuDeviceManufacturerName,
  GpuDeviceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GpuDeviceInfo(
    name: Option[GpuDeviceName] = None,
    manufacturer: Option[GpuDeviceManufacturerName] = None,
    count: Option[GpuDeviceCount] = None,
    memoryInfo: Option[zio.aws.ec2.model.GpuDeviceMemoryInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GpuDeviceInfo = {
    import GpuDeviceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GpuDeviceInfo
      .builder()
      .optionallyWith(
        name.map(value => GpuDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        manufacturer.map(value =>
          GpuDeviceManufacturerName.unwrap(value): java.lang.String
        )
      )(_.manufacturer)
      .optionallyWith(
        count.map(value => GpuDeviceCount.unwrap(value): Integer)
      )(_.count)
      .optionallyWith(memoryInfo.map(value => value.buildAwsValue()))(
        _.memoryInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GpuDeviceInfo.ReadOnly =
    zio.aws.ec2.model.GpuDeviceInfo.wrap(buildAwsValue())
}
object GpuDeviceInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.GpuDeviceInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GpuDeviceInfo =
      zio.aws.ec2.model.GpuDeviceInfo(
        name.map(value => value),
        manufacturer.map(value => value),
        count.map(value => value),
        memoryInfo.map(value => value.asEditable)
      )
    def name: Option[GpuDeviceName]
    def manufacturer: Option[GpuDeviceManufacturerName]
    def count: Option[GpuDeviceCount]
    def memoryInfo: Option[zio.aws.ec2.model.GpuDeviceMemoryInfo.ReadOnly]
    def getName: ZIO[Any, AwsError, GpuDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getManufacturer: ZIO[Any, AwsError, GpuDeviceManufacturerName] =
      AwsError.unwrapOptionField("manufacturer", manufacturer)
    def getCount: ZIO[Any, AwsError, GpuDeviceCount] =
      AwsError.unwrapOptionField("count", count)
    def getMemoryInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.GpuDeviceMemoryInfo.ReadOnly] =
      AwsError.unwrapOptionField("memoryInfo", memoryInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GpuDeviceInfo
  ) extends zio.aws.ec2.model.GpuDeviceInfo.ReadOnly {
    override val name: Option[GpuDeviceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ec2.model.primitives.GpuDeviceName(value))
    override val manufacturer: Option[GpuDeviceManufacturerName] = scala
      .Option(impl.manufacturer())
      .map(value =>
        zio.aws.ec2.model.primitives.GpuDeviceManufacturerName(value)
      )
    override val count: Option[GpuDeviceCount] = scala
      .Option(impl.count())
      .map(value => zio.aws.ec2.model.primitives.GpuDeviceCount(value))
    override val memoryInfo
        : Option[zio.aws.ec2.model.GpuDeviceMemoryInfo.ReadOnly] = scala
      .Option(impl.memoryInfo())
      .map(value => zio.aws.ec2.model.GpuDeviceMemoryInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GpuDeviceInfo
  ): zio.aws.ec2.model.GpuDeviceInfo.ReadOnly = new Wrapper(impl)
}
