package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayRouteTableAssociationsResponse(
    associations: Option[
      Iterable[zio.aws.ec2.model.TransitGatewayRouteTableAssociation]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsResponse = {
    import GetTransitGatewayRouteTableAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsResponse
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsResponse.ReadOnly =
    zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsResponse
      .wrap(buildAwsValue())
}
object GetTransitGatewayRouteTableAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsResponse =
      zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsResponse(
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def associations: Option[
      List[zio.aws.ec2.model.TransitGatewayRouteTableAssociation.ReadOnly]
    ]
    def nextToken: Option[String]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayRouteTableAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsResponse
  ) extends zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsResponse.ReadOnly {
    override val associations: Option[
      List[zio.aws.ec2.model.TransitGatewayRouteTableAssociation.ReadOnly]
    ] = scala
      .Option(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayRouteTableAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsResponse
  ): zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
