package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  IpamPoolId,
  IpamScopeId,
  NextToken,
  IpamMaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetIpamResourceCidrsRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[IpamMaxResults] = None,
    nextToken: Option[NextToken] = None,
    ipamScopeId: IpamScopeId,
    ipamPoolId: Option[IpamPoolId] = None,
    resourceId: Option[String] = None,
    resourceType: Option[zio.aws.ec2.model.IpamResourceType] = None,
    resourceTag: Option[zio.aws.ec2.model.RequestIpamResourceTag] = None,
    resourceOwner: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest = {
    import GetIpamResourceCidrsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => IpamMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .ipamScopeId(IpamScopeId.unwrap(ipamScopeId): java.lang.String)
      .optionallyWith(
        ipamPoolId.map(value => IpamPoolId.unwrap(value): java.lang.String)
      )(_.ipamPoolId)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceTag.map(value => value.buildAwsValue()))(
        _.resourceTag
      )
      .optionallyWith(resourceOwner.map(value => value: java.lang.String))(
        _.resourceOwner
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetIpamResourceCidrsRequest.ReadOnly =
    zio.aws.ec2.model.GetIpamResourceCidrsRequest.wrap(buildAwsValue())
}
object GetIpamResourceCidrsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamResourceCidrsRequest =
      zio.aws.ec2.model.GetIpamResourceCidrsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        ipamScopeId,
        ipamPoolId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        resourceTag.map(value => value.asEditable),
        resourceOwner.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[IpamMaxResults]
    def nextToken: Option[NextToken]
    def ipamScopeId: IpamScopeId
    def ipamPoolId: Option[IpamPoolId]
    def resourceId: Option[String]
    def resourceType: Option[zio.aws.ec2.model.IpamResourceType]
    def resourceTag: Option[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]
    def resourceOwner: Option[String]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, IpamMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIpamScopeId: ZIO[Any, Nothing, IpamScopeId] =
      ZIO.succeed(ipamScopeId)
    def getIpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("ipamPoolId", ipamPoolId)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceTag: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly
    ] = AwsError.unwrapOptionField("resourceTag", resourceTag)
    def getResourceOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest
  ) extends zio.aws.ec2.model.GetIpamResourceCidrsRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[IpamMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.IpamMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val ipamScopeId: IpamScopeId =
      zio.aws.ec2.model.primitives.IpamScopeId(impl.ipamScopeId())
    override val ipamPoolId: Option[IpamPoolId] = scala
      .Option(impl.ipamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val resourceType: Option[zio.aws.ec2.model.IpamResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.ec2.model.IpamResourceType.wrap(value))
    override val resourceTag
        : Option[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly] = scala
      .Option(impl.resourceTag())
      .map(value => zio.aws.ec2.model.RequestIpamResourceTag.wrap(value))
    override val resourceOwner: Option[String] =
      scala.Option(impl.resourceOwner()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest
  ): zio.aws.ec2.model.GetIpamResourceCidrsRequest.ReadOnly = new Wrapper(impl)
}
