package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CapacityReservationFleetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FailedCapacityReservationFleetCancellationResult(
    capacityReservationFleetId: Option[CapacityReservationFleetId] = None,
    cancelCapacityReservationFleetError: Option[
      zio.aws.ec2.model.CancelCapacityReservationFleetError
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FailedCapacityReservationFleetCancellationResult = {
    import FailedCapacityReservationFleetCancellationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FailedCapacityReservationFleetCancellationResult
      .builder()
      .optionallyWith(
        capacityReservationFleetId.map(value =>
          CapacityReservationFleetId.unwrap(value): java.lang.String
        )
      )(_.capacityReservationFleetId)
      .optionallyWith(
        cancelCapacityReservationFleetError.map(value => value.buildAwsValue())
      )(_.cancelCapacityReservationFleetError)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.FailedCapacityReservationFleetCancellationResult.ReadOnly =
    zio.aws.ec2.model.FailedCapacityReservationFleetCancellationResult
      .wrap(buildAwsValue())
}
object FailedCapacityReservationFleetCancellationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FailedCapacityReservationFleetCancellationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.FailedCapacityReservationFleetCancellationResult =
      zio.aws.ec2.model.FailedCapacityReservationFleetCancellationResult(
        capacityReservationFleetId.map(value => value),
        cancelCapacityReservationFleetError.map(value => value.asEditable)
      )
    def capacityReservationFleetId: Option[CapacityReservationFleetId]
    def cancelCapacityReservationFleetError
        : Option[zio.aws.ec2.model.CancelCapacityReservationFleetError.ReadOnly]
    def getCapacityReservationFleetId
        : ZIO[Any, AwsError, CapacityReservationFleetId] =
      AwsError.unwrapOptionField(
        "capacityReservationFleetId",
        capacityReservationFleetId
      )
    def getCancelCapacityReservationFleetError: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CancelCapacityReservationFleetError.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cancelCapacityReservationFleetError",
      cancelCapacityReservationFleetError
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FailedCapacityReservationFleetCancellationResult
  ) extends zio.aws.ec2.model.FailedCapacityReservationFleetCancellationResult.ReadOnly {
    override val capacityReservationFleetId
        : Option[CapacityReservationFleetId] = scala
      .Option(impl.capacityReservationFleetId())
      .map(value =>
        zio.aws.ec2.model.primitives.CapacityReservationFleetId(value)
      )
    override val cancelCapacityReservationFleetError: Option[
      zio.aws.ec2.model.CancelCapacityReservationFleetError.ReadOnly
    ] = scala
      .Option(impl.cancelCapacityReservationFleetError())
      .map(value =>
        zio.aws.ec2.model.CancelCapacityReservationFleetError.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FailedCapacityReservationFleetCancellationResult
  ): zio.aws.ec2.model.FailedCapacityReservationFleetCancellationResult.ReadOnly =
    new Wrapper(impl)
}
