package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportTaskS3LocationRequest(
    s3Bucket: String,
    s3Prefix: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportTaskS3LocationRequest = {
    import ExportTaskS3LocationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportTaskS3LocationRequest
      .builder()
      .s3Bucket(s3Bucket: java.lang.String)
      .optionallyWith(s3Prefix.map(value => value: java.lang.String))(
        _.s3Prefix
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ExportTaskS3LocationRequest.ReadOnly =
    zio.aws.ec2.model.ExportTaskS3LocationRequest.wrap(buildAwsValue())
}
object ExportTaskS3LocationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportTaskS3LocationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ExportTaskS3LocationRequest =
      zio.aws.ec2.model
        .ExportTaskS3LocationRequest(s3Bucket, s3Prefix.map(value => value))
    def s3Bucket: String
    def s3Prefix: Option[String]
    def getS3Bucket: ZIO[Any, Nothing, String] = ZIO.succeed(s3Bucket)
    def getS3Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportTaskS3LocationRequest
  ) extends zio.aws.ec2.model.ExportTaskS3LocationRequest.ReadOnly {
    override val s3Bucket: String = impl.s3Bucket(): String
    override val s3Prefix: Option[String] =
      scala.Option(impl.s3Prefix()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportTaskS3LocationRequest
  ): zio.aws.ec2.model.ExportTaskS3LocationRequest.ReadOnly = new Wrapper(impl)
}
