package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisableImageDeprecationResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableImageDeprecationResponse = {
    import DisableImageDeprecationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableImageDeprecationResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisableImageDeprecationResponse.ReadOnly =
    zio.aws.ec2.model.DisableImageDeprecationResponse.wrap(buildAwsValue())
}
object DisableImageDeprecationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableImageDeprecationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableImageDeprecationResponse =
      zio.aws.ec2.model
        .DisableImageDeprecationResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableImageDeprecationResponse
  ) extends zio.aws.ec2.model.DisableImageDeprecationResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableImageDeprecationResponse
  ): zio.aws.ec2.model.DisableImageDeprecationResponse.ReadOnly = new Wrapper(
    impl
  )
}
