package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  TransitGatewayMaxResults,
  TransitGatewayConnectPeerId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewayConnectPeersRequest(
    transitGatewayConnectPeerIds: Option[
      Iterable[TransitGatewayConnectPeerId]
    ] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[TransitGatewayMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersRequest = {
    import DescribeTransitGatewayConnectPeersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersRequest
      .builder()
      .optionallyWith(
        transitGatewayConnectPeerIds.map(value =>
          value.map { item =>
            TransitGatewayConnectPeerId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.transitGatewayConnectPeerIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => TransitGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTransitGatewayConnectPeersRequest.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewayConnectPeersRequest
      .wrap(buildAwsValue())
}
object DescribeTransitGatewayConnectPeersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTransitGatewayConnectPeersRequest =
      zio.aws.ec2.model.DescribeTransitGatewayConnectPeersRequest(
        transitGatewayConnectPeerIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def transitGatewayConnectPeerIds: Option[List[TransitGatewayConnectPeerId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[TransitGatewayMaxResults]
    def nextToken: Option[String]
    def getTransitGatewayConnectPeerIds
        : ZIO[Any, AwsError, List[TransitGatewayConnectPeerId]] =
      AwsError.unwrapOptionField(
        "transitGatewayConnectPeerIds",
        transitGatewayConnectPeerIds
      )
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, TransitGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersRequest
  ) extends zio.aws.ec2.model.DescribeTransitGatewayConnectPeersRequest.ReadOnly {
    override val transitGatewayConnectPeerIds
        : Option[List[TransitGatewayConnectPeerId]] = scala
      .Option(impl.transitGatewayConnectPeerIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.TransitGatewayConnectPeerId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[TransitGatewayMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersRequest
  ): zio.aws.ec2.model.DescribeTransitGatewayConnectPeersRequest.ReadOnly =
    new Wrapper(impl)
}
