package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInsightsAnalysesResponse(
    networkInsightsAnalyses: Option[
      Iterable[zio.aws.ec2.model.NetworkInsightsAnalysis]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesResponse = {
    import DescribeNetworkInsightsAnalysesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesResponse
      .builder()
      .optionallyWith(
        networkInsightsAnalyses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInsightsAnalyses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInsightsAnalysesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInsightsAnalysesResponse
      .wrap(buildAwsValue())
}
object DescribeNetworkInsightsAnalysesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNetworkInsightsAnalysesResponse =
      zio.aws.ec2.model.DescribeNetworkInsightsAnalysesResponse(
        networkInsightsAnalyses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkInsightsAnalyses
        : Option[List[zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly]]
    def nextToken: Option[String]
    def getNetworkInsightsAnalyses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkInsightsAnalyses",
      networkInsightsAnalyses
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesResponse
  ) extends zio.aws.ec2.model.DescribeNetworkInsightsAnalysesResponse.ReadOnly {
    override val networkInsightsAnalyses
        : Option[List[zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly]] =
      scala
        .Option(impl.networkInsightsAnalyses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.NetworkInsightsAnalysis.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesResponse
  ): zio.aws.ec2.model.DescribeNetworkInsightsAnalysesResponse.ReadOnly =
    new Wrapper(impl)
}
