package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeImageAttributeRequest(
    attribute: zio.aws.ec2.model.ImageAttributeName,
    imageId: ImageId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest = {
    import DescribeImageAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest
      .builder()
      .attribute(attribute.unwrap)
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeImageAttributeRequest.ReadOnly =
    zio.aws.ec2.model.DescribeImageAttributeRequest.wrap(buildAwsValue())
}
object DescribeImageAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImageAttributeRequest =
      zio.aws.ec2.model.DescribeImageAttributeRequest(attribute, imageId)
    def attribute: zio.aws.ec2.model.ImageAttributeName
    def imageId: ImageId
    def getAttribute: ZIO[Any, Nothing, zio.aws.ec2.model.ImageAttributeName] =
      ZIO.succeed(attribute)
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest
  ) extends zio.aws.ec2.model.DescribeImageAttributeRequest.ReadOnly {
    override val attribute: zio.aws.ec2.model.ImageAttributeName =
      zio.aws.ec2.model.ImageAttributeName.wrap(impl.attribute())
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest
  ): zio.aws.ec2.model.DescribeImageAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
