package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeIdentityIdFormatResponse(
    statuses: Option[Iterable[zio.aws.ec2.model.IdFormat]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatResponse = {
    import DescribeIdentityIdFormatResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatResponse
      .builder()
      .optionallyWith(
        statuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statuses)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeIdentityIdFormatResponse.ReadOnly =
    zio.aws.ec2.model.DescribeIdentityIdFormatResponse.wrap(buildAwsValue())
}
object DescribeIdentityIdFormatResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeIdentityIdFormatResponse =
      zio.aws.ec2.model.DescribeIdentityIdFormatResponse(
        statuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def statuses: Option[List[zio.aws.ec2.model.IdFormat.ReadOnly]]
    def getStatuses
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IdFormat.ReadOnly]] =
      AwsError.unwrapOptionField("statuses", statuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatResponse
  ) extends zio.aws.ec2.model.DescribeIdentityIdFormatResponse.ReadOnly {
    override val statuses: Option[List[zio.aws.ec2.model.IdFormat.ReadOnly]] =
      scala
        .Option(impl.statuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IdFormat.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatResponse
  ): zio.aws.ec2.model.DescribeIdentityIdFormatResponse.ReadOnly = new Wrapper(
    impl
  )
}
