package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFleetsInstances(
    launchTemplateAndOverrides: Option[
      zio.aws.ec2.model.LaunchTemplateAndOverridesResponse
    ] = None,
    lifecycle: Option[zio.aws.ec2.model.InstanceLifecycle] = None,
    instanceIds: Option[Iterable[InstanceId]] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    platform: Option[zio.aws.ec2.model.PlatformValues] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFleetsInstances = {
    import DescribeFleetsInstances.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFleetsInstances
      .builder()
      .optionallyWith(
        launchTemplateAndOverrides.map(value => value.buildAwsValue())
      )(_.launchTemplateAndOverrides)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFleetsInstances.ReadOnly =
    zio.aws.ec2.model.DescribeFleetsInstances.wrap(buildAwsValue())
}
object DescribeFleetsInstances {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFleetsInstances
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFleetsInstances =
      zio.aws.ec2.model.DescribeFleetsInstances(
        launchTemplateAndOverrides.map(value => value.asEditable),
        lifecycle.map(value => value),
        instanceIds.map(value => value),
        instanceType.map(value => value),
        platform.map(value => value)
      )
    def launchTemplateAndOverrides
        : Option[zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.ReadOnly]
    def lifecycle: Option[zio.aws.ec2.model.InstanceLifecycle]
    def instanceIds: Option[List[InstanceId]]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def platform: Option[zio.aws.ec2.model.PlatformValues]
    def getLaunchTemplateAndOverrides: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "launchTemplateAndOverrides",
      launchTemplateAndOverrides
    )
    def getLifecycle: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getInstanceIds: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getPlatform: ZIO[Any, AwsError, zio.aws.ec2.model.PlatformValues] =
      AwsError.unwrapOptionField("platform", platform)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetsInstances
  ) extends zio.aws.ec2.model.DescribeFleetsInstances.ReadOnly {
    override val launchTemplateAndOverrides: Option[
      zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.ReadOnly
    ] = scala
      .Option(impl.launchTemplateAndOverrides())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.wrap(value)
      )
    override val lifecycle: Option[zio.aws.ec2.model.InstanceLifecycle] = scala
      .Option(impl.lifecycle())
      .map(value => zio.aws.ec2.model.InstanceLifecycle.wrap(value))
    override val instanceIds: Option[List[InstanceId]] = scala
      .Option(impl.instanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.InstanceId(item)
        }.toList
      )
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val platform: Option[zio.aws.ec2.model.PlatformValues] = scala
      .Option(impl.platform())
      .map(value => zio.aws.ec2.model.PlatformValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetsInstances
  ): zio.aws.ec2.model.DescribeFleetsInstances.ReadOnly = new Wrapper(impl)
}
