package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  NetworkInterfaceId,
  TransitGatewayMulticastDomainId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeregisterTransitGatewayMulticastGroupSourcesRequest(
    transitGatewayMulticastDomainId: Option[TransitGatewayMulticastDomainId] =
      None,
    groupIpAddress: Option[String] = None,
    networkInterfaceIds: Option[Iterable[NetworkInterfaceId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest = {
    import DeregisterTransitGatewayMulticastGroupSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value =>
          TransitGatewayMulticastDomainId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(groupIpAddress.map(value => value: java.lang.String))(
        _.groupIpAddress
      )
      .optionallyWith(
        networkInterfaceIds.map(value =>
          value.map { item =>
            NetworkInterfaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfaceIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest.ReadOnly =
    zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
      .wrap(buildAwsValue())
}
object DeregisterTransitGatewayMulticastGroupSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest =
      zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest(
        transitGatewayMulticastDomainId.map(value => value),
        groupIpAddress.map(value => value),
        networkInterfaceIds.map(value => value)
      )
    def transitGatewayMulticastDomainId: Option[TransitGatewayMulticastDomainId]
    def groupIpAddress: Option[String]
    def networkInterfaceIds: Option[List[NetworkInterfaceId]]
    def getTransitGatewayMulticastDomainId
        : ZIO[Any, AwsError, TransitGatewayMulticastDomainId] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getGroupIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupIpAddress", groupIpAddress)
    def getNetworkInterfaceIds: ZIO[Any, AwsError, List[NetworkInterfaceId]] =
      AwsError.unwrapOptionField("networkInterfaceIds", networkInterfaceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
  ) extends zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest.ReadOnly {
    override val transitGatewayMulticastDomainId
        : Option[TransitGatewayMulticastDomainId] = scala
      .Option(impl.transitGatewayMulticastDomainId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMulticastDomainId(value)
      )
    override val groupIpAddress: Option[String] =
      scala.Option(impl.groupIpAddress()).map(value => value: String)
    override val networkInterfaceIds: Option[List[NetworkInterfaceId]] = scala
      .Option(impl.networkInterfaceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.NetworkInterfaceId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
  ): zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest.ReadOnly =
    new Wrapper(impl)
}
