package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayAttachmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayPeeringAttachmentRequest(
    transitGatewayAttachmentId: TransitGatewayAttachmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest = {
    import DeleteTransitGatewayPeeringAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest
      .builder()
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayPeeringAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest =
      zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest(
        transitGatewayAttachmentId
      )
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest
  ) extends zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest.ReadOnly {
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest
  ): zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
