package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteManagedPrefixListResponse(
    prefixList: Option[zio.aws.ec2.model.ManagedPrefixList] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListResponse = {
    import DeleteManagedPrefixListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListResponse
      .builder()
      .optionallyWith(prefixList.map(value => value.buildAwsValue()))(
        _.prefixList
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteManagedPrefixListResponse.ReadOnly =
    zio.aws.ec2.model.DeleteManagedPrefixListResponse.wrap(buildAwsValue())
}
object DeleteManagedPrefixListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteManagedPrefixListResponse =
      zio.aws.ec2.model.DeleteManagedPrefixListResponse(
        prefixList.map(value => value.asEditable)
      )
    def prefixList: Option[zio.aws.ec2.model.ManagedPrefixList.ReadOnly]
    def getPrefixList
        : ZIO[Any, AwsError, zio.aws.ec2.model.ManagedPrefixList.ReadOnly] =
      AwsError.unwrapOptionField("prefixList", prefixList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListResponse
  ) extends zio.aws.ec2.model.DeleteManagedPrefixListResponse.ReadOnly {
    override val prefixList
        : Option[zio.aws.ec2.model.ManagedPrefixList.ReadOnly] = scala
      .Option(impl.prefixList())
      .map(value => zio.aws.ec2.model.ManagedPrefixList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListResponse
  ): zio.aws.ec2.model.DeleteManagedPrefixListResponse.ReadOnly = new Wrapper(
    impl
  )
}
