package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpcResponse(vpc: Option[zio.aws.ec2.model.Vpc] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcResponse = {
    import CreateVpcResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcResponse
      .builder()
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpcResponse.ReadOnly =
    zio.aws.ec2.model.CreateVpcResponse.wrap(buildAwsValue())
}
object CreateVpcResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpcResponse =
      zio.aws.ec2.model.CreateVpcResponse(vpc.map(value => value.asEditable))
    def vpc: Option[zio.aws.ec2.model.Vpc.ReadOnly]
    def getVpc: ZIO[Any, AwsError, zio.aws.ec2.model.Vpc.ReadOnly] =
      AwsError.unwrapOptionField("vpc", vpc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcResponse
  ) extends zio.aws.ec2.model.CreateVpcResponse.ReadOnly {
    override val vpc: Option[zio.aws.ec2.model.Vpc.ReadOnly] =
      scala.Option(impl.vpc()).map(value => zio.aws.ec2.model.Vpc.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcResponse
  ): zio.aws.ec2.model.CreateVpcResponse.ReadOnly = new Wrapper(impl)
}
