package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SubnetId, VpcId, TransitGatewayId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayVpcAttachmentRequest(
    transitGatewayId: TransitGatewayId,
    vpcId: VpcId,
    subnetIds: Iterable[SubnetId],
    options: Option[
      zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequestOptions
    ] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentRequest = {
    import CreateTransitGatewayVpcAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentRequest
      .builder()
      .transitGatewayId(
        TransitGatewayId.unwrap(transitGatewayId): java.lang.String
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequest.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequest
      .wrap(buildAwsValue())
}
object CreateTransitGatewayVpcAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequest =
      zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequest(
        transitGatewayId,
        vpcId,
        subnetIds,
        options.map(value => value.asEditable),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayId: TransitGatewayId
    def vpcId: VpcId
    def subnetIds: List[SubnetId]
    def options: Option[
      zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequestOptions.ReadOnly
    ]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getTransitGatewayId: ZIO[Any, Nothing, TransitGatewayId] =
      ZIO.succeed(transitGatewayId)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequestOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentRequest
  ) extends zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequest.ReadOnly {
    override val transitGatewayId: TransitGatewayId =
      zio.aws.ec2.model.primitives.TransitGatewayId(impl.transitGatewayId())
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.SubnetId(item)
      }
      .toList
    override val options: Option[
      zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequestOptions.ReadOnly
    ] = scala
      .Option(impl.options())
      .map(value =>
        zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequestOptions
          .wrap(value)
      )
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentRequest
  ): zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
