package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayRouteResponse(
    route: Option[zio.aws.ec2.model.TransitGatewayRoute] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteResponse = {
    import CreateTransitGatewayRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteResponse
      .builder()
      .optionallyWith(route.map(value => value.buildAwsValue()))(_.route)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateTransitGatewayRouteResponse.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayRouteResponse.wrap(buildAwsValue())
}
object CreateTransitGatewayRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTransitGatewayRouteResponse =
      zio.aws.ec2.model
        .CreateTransitGatewayRouteResponse(route.map(value => value.asEditable))
    def route: Option[zio.aws.ec2.model.TransitGatewayRoute.ReadOnly]
    def getRoute
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayRoute.ReadOnly] =
      AwsError.unwrapOptionField("route", route)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteResponse
  ) extends zio.aws.ec2.model.CreateTransitGatewayRouteResponse.ReadOnly {
    override val route: Option[zio.aws.ec2.model.TransitGatewayRoute.ReadOnly] =
      scala
        .Option(impl.route())
        .map(value => zio.aws.ec2.model.TransitGatewayRoute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteResponse
  ): zio.aws.ec2.model.CreateTransitGatewayRouteResponse.ReadOnly = new Wrapper(
    impl
  )
}
