package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInterfaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTrafficMirrorTargetRequest(
    networkInterfaceId: Option[NetworkInterfaceId] = None,
    networkLoadBalancerArn: Option[String] = None,
    description: Option[String] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest = {
    import CreateTrafficMirrorTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest
      .builder()
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        networkLoadBalancerArn.map(value => value: java.lang.String)
      )(_.networkLoadBalancerArn)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateTrafficMirrorTargetRequest.ReadOnly =
    zio.aws.ec2.model.CreateTrafficMirrorTargetRequest.wrap(buildAwsValue())
}
object CreateTrafficMirrorTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTrafficMirrorTargetRequest =
      zio.aws.ec2.model.CreateTrafficMirrorTargetRequest(
        networkInterfaceId.map(value => value),
        networkLoadBalancerArn.map(value => value),
        description.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def networkInterfaceId: Option[NetworkInterfaceId]
    def networkLoadBalancerArn: Option[String]
    def description: Option[String]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: Option[String]
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getNetworkLoadBalancerArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("networkLoadBalancerArn", networkLoadBalancerArn)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest
  ) extends zio.aws.ec2.model.CreateTrafficMirrorTargetRequest.ReadOnly {
    override val networkInterfaceId: Option[NetworkInterfaceId] = scala
      .Option(impl.networkInterfaceId())
      .map(value => zio.aws.ec2.model.primitives.NetworkInterfaceId(value))
    override val networkLoadBalancerArn: Option[String] =
      scala.Option(impl.networkLoadBalancerArn()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest
  ): zio.aws.ec2.model.CreateTrafficMirrorTargetRequest.ReadOnly = new Wrapper(
    impl
  )
}
