package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateRestoreImageTaskRequest(
    bucket: String,
    objectKey: String,
    name: Option[String] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest = {
    import CreateRestoreImageTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .objectKey(objectKey: java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateRestoreImageTaskRequest.ReadOnly =
    zio.aws.ec2.model.CreateRestoreImageTaskRequest.wrap(buildAwsValue())
}
object CreateRestoreImageTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateRestoreImageTaskRequest =
      zio.aws.ec2.model.CreateRestoreImageTaskRequest(
        bucket,
        objectKey,
        name.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bucket: String
    def objectKey: String
    def name: Option[String]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getBucket: ZIO[Any, Nothing, String] = ZIO.succeed(bucket)
    def getObjectKey: ZIO[Any, Nothing, String] = ZIO.succeed(objectKey)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest
  ) extends zio.aws.ec2.model.CreateRestoreImageTaskRequest.ReadOnly {
    override val bucket: String = impl.bucket(): String
    override val objectKey: String = impl.objectKey(): String
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest
  ): zio.aws.ec2.model.CreateRestoreImageTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
