package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCarrierGatewayResponse(
    carrierGateway: Option[zio.aws.ec2.model.CarrierGateway] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayResponse = {
    import CreateCarrierGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayResponse
      .builder()
      .optionallyWith(carrierGateway.map(value => value.buildAwsValue()))(
        _.carrierGateway
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateCarrierGatewayResponse.ReadOnly =
    zio.aws.ec2.model.CreateCarrierGatewayResponse.wrap(buildAwsValue())
}
object CreateCarrierGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCarrierGatewayResponse =
      zio.aws.ec2.model.CreateCarrierGatewayResponse(
        carrierGateway.map(value => value.asEditable)
      )
    def carrierGateway: Option[zio.aws.ec2.model.CarrierGateway.ReadOnly]
    def getCarrierGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.CarrierGateway.ReadOnly] =
      AwsError.unwrapOptionField("carrierGateway", carrierGateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayResponse
  ) extends zio.aws.ec2.model.CreateCarrierGatewayResponse.ReadOnly {
    override val carrierGateway
        : Option[zio.aws.ec2.model.CarrierGateway.ReadOnly] = scala
      .Option(impl.carrierGateway())
      .map(value => zio.aws.ec2.model.CarrierGateway.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayResponse
  ): zio.aws.ec2.model.CreateCarrierGatewayResponse.ReadOnly = new Wrapper(impl)
}
