package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClientConnectOptions(
    enabled: Option[Boolean] = None,
    lambdaFunctionArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientConnectOptions = {
    import ClientConnectOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientConnectOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(lambdaFunctionArn.map(value => value: java.lang.String))(
        _.lambdaFunctionArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientConnectOptions.ReadOnly =
    zio.aws.ec2.model.ClientConnectOptions.wrap(buildAwsValue())
}
object ClientConnectOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientConnectOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientConnectOptions =
      zio.aws.ec2.model.ClientConnectOptions(
        enabled.map(value => value),
        lambdaFunctionArn.map(value => value)
      )
    def enabled: Option[Boolean]
    def lambdaFunctionArn: Option[String]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getLambdaFunctionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lambdaFunctionArn", lambdaFunctionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientConnectOptions
  ) extends zio.aws.ec2.model.ClientConnectOptions.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val lambdaFunctionArn: Option[String] =
      scala.Option(impl.lambdaFunctionArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientConnectOptions
  ): zio.aws.ec2.model.ClientConnectOptions.ReadOnly = new Wrapper(impl)
}
