package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CertificateAuthenticationRequest(
    clientRootCertificateChainArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CertificateAuthenticationRequest = {
    import CertificateAuthenticationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CertificateAuthenticationRequest
      .builder()
      .optionallyWith(
        clientRootCertificateChainArn.map(value => value: java.lang.String)
      )(_.clientRootCertificateChainArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CertificateAuthenticationRequest.ReadOnly =
    zio.aws.ec2.model.CertificateAuthenticationRequest.wrap(buildAwsValue())
}
object CertificateAuthenticationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CertificateAuthenticationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CertificateAuthenticationRequest =
      zio.aws.ec2.model.CertificateAuthenticationRequest(
        clientRootCertificateChainArn.map(value => value)
      )
    def clientRootCertificateChainArn: Option[String]
    def getClientRootCertificateChainArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "clientRootCertificateChainArn",
        clientRootCertificateChainArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CertificateAuthenticationRequest
  ) extends zio.aws.ec2.model.CertificateAuthenticationRequest.ReadOnly {
    override val clientRootCertificateChainArn: Option[String] = scala
      .Option(impl.clientRootCertificateChainArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CertificateAuthenticationRequest
  ): zio.aws.ec2.model.CertificateAuthenticationRequest.ReadOnly = new Wrapper(
    impl
  )
}
